 ////------------//
 ///**SplitScreen to OneScreen 4Players**///
 //------------////
 
 //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 //* Stereo Input Converter 1.2                           																														*//
 //* For Reshade 3.0																																								*//
 //* --------------------------																																						*//
 //* This work is licensed under a Creative Commons Attribution 3.0 Unported License.																								*//
 //* So you are free to share, modify and adapt it for your needs, and even use it for commercial use.																				*//
 //* I would also love to hear about a project you are using it with.																												*//
 //* https://creativecommons.org/licenses/by/3.0/us/																																*//
 //*																																												*//
 //*																																												*//
 //* Modified by: carlosXDjav																																												*//
 //*																																												*//
 //*																																												*//
 //* Original shader 3d_to_else by:																																										*//
 //* Jose Negrete AKA BlueSkyDefender																																				*//
 //*																																												*//
 //* http://reshade.me/forum/shader-presentation/2128-sidebyside-3d-depth-map-based-stereoscopic-shader																				*//	
 //* ---------------------------------																																				*//
 //*																																												*//
 //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
uniform bool enable_system <
	ui_label = "Active System (Netplay Only)";
	ui_tooltip = "on/off.";
> = true;
uniform int screen_for <
	ui_label = "Main Screen";
	ui_type = "combo";
	ui_items = "Player 1\0Player 2\0Player 3\0Player 4\0";
	ui_tooltip = "P1 P2 P3 P4.";
> = 0;


/////////////////////////////////////////////D3D Starts Here/////////////////////////////////////////////////////////////////
#define pix float2(BUFFER_RCP_WIDTH, BUFFER_RCP_HEIGHT)
#define TextureSize float2(BUFFER_WIDTH, BUFFER_HEIGHT)
uniform float frametime < source = "frametime";>;
uniform float timer < source = "timer"; >;	

texture BackBufferTex : COLOR;

sampler BackBuffer 
	{ 
		Texture = BackBufferTex;
		MagFilter = POINT;
		MinFilter = POINT;
		MipFilter = POINT;
	};

texture texcL_P1  { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8;}; 

sampler SamplercL_P1
	{
		Texture = texcL_P1;
		AddressU = BORDER;
		AddressV = BORDER;
		AddressW = BORDER;
	};
texture Current_BackBuffer_Tex  { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; }; 

sampler CBackBuffer
	{
		Texture = Current_BackBuffer_Tex;
		MagFilter = POINT;
		MinFilter = POINT;
		MipFilter = POINT;
	};

texture PastSingleBackBuffer  { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8;}; 
sampler PSBackBuffer
	{
		Texture = PastSingleBackBuffer;
		MagFilter = POINT;
		MinFilter = POINT;
		MipFilter = POINT;
	};
 
//Stereo Texture grabber
float4 BB_Texture(float2 TC)
{
	if(2 == 1)
		TC.y = 0 ? TC.y * 0.5 + 0.25 : TC.y;
	float4 Color = tex2Dlod(BackBuffer, float4(TC,0,0) ), Exp_Darks, Exp_BP2s;
	        	 
	float3 AdaptColor = tex2Dlod(BackBuffer, float4(TC,0,0) ).rgb;
	
    return float4(Color.rgb,max(AdaptColor.r, max(AdaptColor.g, AdaptColor.b)));
}

void PS_InputLR(in float4 position : SV_Position, in float2 texcoord : TEXCOORD0, out float4 mainScreen : SV_Target0)
{	
float4 P1, P2, P3, P4;
	float P = 0 * pix.x;
	if(enable_system == 1)
	{
		//Captura de pantalla
		P1 =  BB_Texture(float2(texcoord.x*0.5 + P,texcoord.y*0.5));
		P2 = BB_Texture(float2((texcoord.x*0.5+0.5)- P,texcoord.y*0.5));
		P3 = BB_Texture(float2(texcoord.x*0.5 + P,texcoord.y*0.5+0.5));
		P4 = BB_Texture(float2((texcoord.x*0.5+0.5)- P,texcoord.y*0.5+0.5));

	//Show the correct screens
	if(screen_for == 0)
	{
	mainScreen = P1;
	}
	else if(screen_for == 1)
	{
	mainScreen = P2;
	}
	else if(screen_for == 2)
	{
	mainScreen = P3;
	}
	else if(screen_for == 3)
	{
	mainScreen = P4;
	}
	}
	else
	{
	mainScreen = BB_Texture(float2(texcoord.x + P,texcoord.y));
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
float4 toElse(float2 texcoord)
{


	float4 image = 1, cL_P1, L, R, Out, accum;
	float2 TcL_P1, StoreTC = texcoord;
	float P = 0;//0 * pix.x;
	
			TcL_P1.x = texcoord.x + P;
			TcL_P1.y = texcoord.y;

		//Optimization for line & column interlaced out.
			TcL_P1.y = TcL_P1.y + (float2(0,0).x * pix.y);
		
		//Muestra de pantalla
            cL_P1 = tex2D(SamplercL_P1,float2(TcL_P1.x,TcL_P1.y));
		Out = texcoord.y < 1 ? cL_P1 : cL_P1;
	
	return Out;

}

void Current_BackBuffer(float4 position : SV_Position, float2 texcoord : TEXCOORD, out float4 color : SV_Target)
{	 	
	color = BB_Texture(texcoord);
}

void Past_BackBuffer(float4 position : SV_Position, float2 texcoord : TEXCOORD, out float4 PastSingle : SV_Target0)
{
		PastSingle = tex2D(CBackBuffer,texcoord);
}
////////////////////////////////////////////////////////Fin/////////////////////////////////////////////////////////////////////////
float4 Out(float4 position : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	float3 Color = 2 == 0 ? BB_Texture(texcoord).rgb : toElse(texcoord).rgb;
	return float4(Color,1.);
}

///////////////////////////////////////////////////////////ReShade.fxh/////////////////////////////////////////////////////////////
// Vertex shader generating a triangle covering the entire screen
void PostProcessVS(in uint id : SV_VertexID, out float4 position : SV_Position, out float2 texcoord : TEXCOORD)
{
	texcoord.x = (id == 2) ? 2.0 : 0.0;
	texcoord.y = (id == 1) ? 2.0 : 0.0;
	position = float4(texcoord * float2(2.0, -2.0) + float2(-1.0, 1.0), 0.0, 1.0);
}

//*Rendering passes*//
technique SplitScreen_to_OneScreen_4P
{		
			pass PBB
		{
			VertexShader = PostProcessVS;
			PixelShader = Past_BackBuffer;
			RenderTarget = PastSingleBackBuffer;
		}
			pass CBB
		{
			VertexShader = PostProcessVS;
			PixelShader = Current_BackBuffer;
			RenderTarget = Current_BackBuffer_Tex;
		}
			pass StereoInput
		{
			VertexShader = PostProcessVS;
			PixelShader = PS_InputLR;
			RenderTarget0 = texcL_P1;
		}
			pass StereoToElse
		{
			VertexShader = PostProcessVS;
			PixelShader = Out;	
		}		
}